/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.data;

import com.supermartijn642.core.generator.BlockStateGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.block.BlockSpecification;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class RechiseledBlockStateGenerator
extends BlockStateGenerator {
    private static final Map<BlockSpecification, List<Supplier<Block>>> BLOCKS = new EnumMap<BlockSpecification, List<Supplier<Block>>>(BlockSpecification.class);

    public static void addBlock(BlockSpecification specification, Supplier<Block> blockSupplier) {
        BLOCKS.computeIfAbsent(specification, s -> new ArrayList()).add(blockSupplier);
    }

    public RechiseledBlockStateGenerator(ResourceCache cache) {
        super("rechiseled", cache);
    }

    public void generate() {
        BLOCKS.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(block -> Pair.of((Object)((Object)((BlockSpecification)((Object)((Object)((Object)entry.getKey()))))), (Object)block))).forEach(entry -> {
            BlockSpecification specification = (BlockSpecification)((Object)((Object)entry.left()));
            Block block = (Block)((Supplier)entry.right()).get();
            ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)block);
            if (specification == BlockSpecification.BASIC) {
                this.blockState(block).emptyVariant(variant -> variant.model(identifier.m_135827_(), "block/" + identifier.m_135815_()));
            }
        });
    }
}

